<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package noble_house_theme_web
 */

$logo_footer = get_theme_mod('logo_footer');
$feature1_id = attachment_url_to_postid($logo_footer);
// This is getting the alt text from the image that is set in the media area
$image1_alt = get_post_meta( $feature1_id, '_wp_attachment_image_alt', true );

?>

<footer id="colophon" class="site-footer">
    <div class="footer_top">
        <div class="middle_container">
            <div class="parent_columns_footer">
                <div class="footer_col col1_footer">
                    <?php 
                    echo '<a href="'.site_url().'"  target="_blank" class="footer_logo_st" ><img class="footer_logo"  src="'.$logo_footer.'" alt="'.$image1_alt.'" /></a>'; 
                    ?>
                </div>
            </div>
        </div>
    </div>
    <div class="footer_bottom">
            <div class="middle_container">

            <div class="copyright_txt_left">The YWCA Darien/Norwalk is a 501(c)(3) organization and your membership is tax deductible to the extent allowable by law. All Rights Reserved. © YWCA Darien/Norwalk.</div>
            <div class="copyright_txt_right">Design and Development by <a href="https://www.noblehousemedia.com/" target="_blank">Noble House Media Group</a></div>
    </div>
    </div>
</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>
<link rel='stylesheet' id='font-awesome.min.css-css'  href='<?php echo bloginfo('stylesheet_directory');?>/css/font-awesome.min.css'  media='all' />


</body>
</html>
