<?php
/*
Widget Name: Title Widget
Description: 
*/

class Title_r_b extends SiteOrigin_Widget {

	function get_template_name($instance) {
    return 'widget-template';
}

function get_template_dir($instance) {
    return 'templates';
}

function __construct() {
   
    //Call the parent constructor with the required arguments.
    parent::__construct(
        // The unique id for your widget.
        'title-r-b',

        // The name of the widget for display purposes.
        'Title Widget',

        // The $widget_options array, which is passed through to WP_Widget.
        // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
         array(
            'panels_groups' => array('nh')
        ),

        //The $control_options array, which is passed through to WP_Widget
        array(
        ),

        //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
        array(	
				'class_custom' => array(
					'type' => 'text',
					'label' => __('Custom class(Do not delete)', 'widget-form-fields-text-domain'),
					'default' => ''
				),
				'title_position' => array(
					'type' => 'select',
					'label' => __( 'Title position', 'widget-form-fields-text-domain' ),
					'default' => 'center_title',
					'options' => array(
						'center_title' => __( 'Center', 'widget-form-fields-text-domain' ),
						'left_title' => __( 'Left', 'widget-form-fields-text-domain' ),
						'right_title' => __( 'Right', 'widget-form-fields-text-domain' ),
						
					)
				),
				'font_weight' => array(
					'type' => 'select',
					'label' => __( 'Font weight', 'widget-form-fields-text-domain' ),
					'default' => 'weight_700',
					'options' => array(
                                            	'weight_300' => __( '300', 'widget-form-fields-text-domain' ),
						'weight_400' => __( '400', 'widget-form-fields-text-domain' ),
						'weight_700' => __( '700', 'widget-form-fields-text-domain' ),
						'weight_800' => __( '800', 'widget-form-fields-text-domain' ),
						
					)
				),
				'font_family' => array(
					'type' => 'select',
					'label' => __( 'Font family', 'widget-form-fields-text-domain' ),
					'default' => 'font_baske',
					'options' => array(
                                            	'font_baske' => __( 'Baskerville', 'widget-form-fields-text-domain' ),
						'font_museo' => __( 'Museo', 'widget-form-fields-text-domain' ),						
					)
				),
				'heading_selection' => array(
					'type' => 'select',
					'label' => __( 'Choose title tag', 'widget-form-fields-text-domain' ),
					'default' => 'h2',
					'options' => array(
						'h1' => __( 'Heading 1', 'widget-form-fields-text-domain' ),
						'h2' => __( 'Heading 2', 'widget-form-fields-text-domain' ),
						'h3' => __( 'Heading 3', 'widget-form-fields-text-domain' ),
						'h4' => __( 'Heading 4', 'widget-form-fields-text-domain' ),
						'h5' => __( 'Heading 5', 'widget-form-fields-text-domain' ),
						'h6' => __( 'Heading 6', 'widget-form-fields-text-domain' ),
						'p' => __( 'Paragraph', 'widget-form-fields-text-domain' ),
					)
				),
				'title_text' => array(
					'type' => 'textarea',
					'label' => __( 'Title Text', 'widget-form-fields-text-domain' ),
					'default' => '',
					'rows' => 10
				),
				'color_text' => array(
					'type' => 'select',
					'label' => __( 'Choose title color', 'widget-form-fields-text-domain' ),
					'default' => 'dark_blue_title',
					'options' => array(
						'black_title' => __( 'Black', 'widget-form-fields-text-domain' ),
						'dark_blue_title' => __( 'Dark Blue', 'widget-form-fields-text-domain' ),
						'white_title' => __( 'White', 'widget-form-fields-text-domain' ),
						'light_blue_title' => __( 'Light Blue', 'widget-form-fields-text-domain' ),
					)
				),
			
				'link_title' => array(
					'type' => 'link',
					'label' => __('Link title(optional)', 'widget-form-fields-text-domain'),
				),
				'target_link' => array(
					'type' => 'select',
					'label' => __( 'Target Link', 'widget-form-fields-text-domain' ),
					'default' => '_self',
					'options' => array(
						'_self' => __( 'Same tab', 'widget-form-fields-text-domain' ),
						'_blank' => __( 'New tab', 'widget-form-fields-text-domain' ),
						
					)
				),

			),

        plugin_dir_path(__FILE__)
    );
}
}

siteorigin_widget_register('title-r-b', __FILE__, 'Title_r_b');